<?php

namespace App\Http;

use Exception;
use GearmanException;
use GearmanJob;
use GearmanWorker;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Handler\CurlHandler;
use GuzzleHttp\HandlerStack;
use GuzzleTor\Middleware;
use Illuminate\Console\Command;
use Log;

class Helper{
    public static function tor(){
        $stack = new HandlerStack();
        $stack->setHandler(new CurlHandler());
        $stack->push(Middleware::tor());
        $client = new Client(['handler' => $stack]);

        $response = $client->get('https://check.torproject.org/', [
            'tor_new_identity'           => true,
            'tor_new_identity_sleep'     => 5,
            'tor_new_identity_timeout'   => 3,
            'tor_new_identity_exception' => true,
            'tor_control_password'       => env('TOR_PASS'),
        ]);

        if (preg_match('/<strong>([\d.]+)<\/strong>/', $response->getBody(), $matches)) {
            return $matches[1];
        } else {
            return null;
        }
    }

    public static function query($url){
        try{
            $client = new Client();
            $response = $client->get($url, [
                'proxy' => 'socks5://127.0.0.1:9050'
            ]);

            if($response->getStatusCode() == 200){
                return $response->getBody()->getContents();
            }
        }catch (ConnectException $e){
            self::tor();
            return self::query($url);
        }catch (ClientException $e){
            return false;
        }

        return false;
    }

    public static function createWorker($name, Command &$handler, $function = 'Worker'){
        $terminate = false;
        pcntl_signal(SIGINT, function() use (&$terminate) {
            $terminate = true;
        });
        pcntl_signal(SIGTERM, function() use (&$terminate) {
            $terminate = true;
        });

        $worker = new GearmanWorker();
        $worker->addOptions(GEARMAN_WORKER_NON_BLOCKING);
        $worker->setTimeout(1000);
        if ( ! $worker->addServer(env('GEARMAN'), 4730) ) {
            throw new GearmanException($worker->error());
        }

        $worker->addFunction($name, function(GearmanJob $job) use(&$handler, $function) {
            try {
                return $handler->$function($job);
            } catch(Exception $e) {
                Log::error($e);
                throw $e;
            }
        });

        while(true){
            if ( $terminate ) {
                break;
            } else {
                pcntl_signal_dispatch();
            }

            $worker->work();

            if ( $terminate ) {
                break;
            } else {
                pcntl_signal_dispatch();
            }

            if ( GEARMAN_SUCCESS == $worker->returnCode() ) {
                continue;
            }

            if ( GEARMAN_IO_WAIT != $worker->returnCode() && GEARMAN_NO_JOBS != $worker->returnCode() ) {
                Log::error('Error [ ' . $worker->returnCode() . ' ]: ' . $worker->error());
                break;
            }

            $worker->wait();
        }

        $worker->unregisterAll();
    }
}